# AI dla gier wideo — zostań mistrzem Snake’a
# Wdrażanie głębokiego Q-learningu za pomocą pamięci doświadczeń

# Importowanie bibliotek
import numpy as np

# WDRAŻANIE GŁĘBOKIEGO Q-LEARNINGU ZA POMOCĄ PAMIĘCI DOŚWIADCZEŃ

class Dqn(object):
    
    # WPROWADZENIE I INICJALIZACJA WSZYSTKICH PARAMETRÓW I ZMIENNYCH DQN
    def __init__(self, max_memory = 100, discount = 0.9):
        self.memory = list()
        self.max_memory = max_memory
        self.discount = discount

    # TWORZENIE METODY, KTÓRA BUDUJE PAMIĘĆ DOŚWIADCZEŃ
    def remember(self, transition, game_over):
        self.memory.append([transition, game_over])
        if len(self.memory) > self.max_memory:
            del self.memory[0]

    # TWORZENIE METODY, KTÓRA BUDUJE DWIE GRUPY WEJŚĆ I CELÓW PRZEZ POBIERANIE PRZEJŚĆ Z PAMIĘCI
    def get_batch(self, model, batch_size = 10):
        len_memory = len(self.memory)
        num_outputs = model.output_shape[-1]
        
        # Modyfikacja grup wejściowych do pracy ze stanami 3D 
        inputs = np.zeros((min(len_memory, batch_size), self.memory[0][0][0].shape[1],self.memory[0][0][0].shape[2],self.memory[0][0][0].shape[3]))
        
        targets = np.zeros((min(len_memory, batch_size), num_outputs))
        for i, idx in enumerate(np.random.randint(0, len_memory, size = min(len_memory, batch_size))):
            current_state, action, reward, next_state = self.memory[idx][0]
            game_over = self.memory[idx][1]
            inputs[i] = current_state
            targets[i] = model.predict(current_state)[0]
            Q_sa = np.max(model.predict(next_state)[0])
            if game_over:
                targets[i, action] = reward
            else:
                targets[i, action] = reward + self.discount * Q_sa
        return inputs, targets


   
